/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.TrayIcon;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class SimpleSPPServer
implements Runnable {
    public static boolean bluetoothShowing = false;
    public double mx;
    public double my;
    public int i = 0;
    public Robot r = null;
    public byte dx;
    public byte dy;
    public int heartbeat = 30;
    public static String devName;
    public static String localDevName;
    Timer task;
    LocalDevice localDevice;
    StreamConnectionNotifier streamConnNotifier = null;
    StreamConnection connection = null;
    RemoteDevice dev = null;
    InputStream inStream = null;
    BufferedOutputStream outputStream = null;
    BufferedInputStream bis;
    public static boolean alive;

    @Override
    public void run() {
        bluetoothShowing = true;
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            Main.localAddressValue.setText(this.localDevice.getBluetoothAddress());
            Main.localAddressValue.setForeground(CustomUtilities.modernBlue);
            Main.localNameValue.setText(this.localDevice.getFriendlyName());
            Main.localNameValue.setForeground(CustomUtilities.modernBlue);
            localDevName = this.localDevice.getFriendlyName();
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
            Main.localAddressValue.setText("No device address found.");
            Main.localAddressValue.setForeground(Color.RED);
            Main.localNameValue.setText("No device name found.");
            Main.localNameValue.setForeground(Color.RED);
            Main.connectionInfoValue.setText("Bluetooth not supported.");
            Main.connectionInfoValue.setForeground(Color.RED);
        }
        try {
            this.r = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        UUID uuid = new UUID("1101", true);
        String connectionString = "btspp://localhost:" + uuid + ";name=Sample SPP Server";
        try {
            this.streamConnNotifier = (StreamConnectionNotifier)Connector.open(connectionString);
        }
        catch (IOException e) {
            Main.connectionInfoValue.setText("Bluetooth not supported.");
            Main.connectionInfoValue.setForeground(Color.RED);
            Main.handleException(e);
        }
        while (bluetoothShowing) {
            System.out.println("\nServer Started. Waiting for clients to connect...");
            try {
                this.connection = this.streamConnNotifier.acceptAndOpen();
                System.out.println("\nConnection acquired");
            }
            catch (IOException e) {
                Main.connectionInfoValue.setText("Connection lost.");
                Main.connectionInfoValue.setForeground(Color.RED);
                Main.handleException(e);
            }
            try {
                this.dev = RemoteDevice.getRemoteDevice(this.connection);
            }
            catch (IOException e) {
                Main.handleException(e);
                Main.connectionInfoValue.setText("Connection lost.");
                Main.connectionInfoValue.setForeground(Color.RED);
            }
            Main.connectionInfoValue.setText("CONNECTING");
            Main.connectionInfoValue.setForeground(Color.YELLOW.darker());
            Main.remoteAddressValue.setText(this.dev.getBluetoothAddress());
            Main.remoteAddressValue.setForeground(CustomUtilities.modernBlue);
            try {
                Main.remoteNameValue.setText(this.dev.getFriendlyName(true));
                Main.remoteNameValue.setForeground(CustomUtilities.modernBlue);
            }
            catch (IOException e) {
                Main.handleException(e);
                Main.remoteNameValue.setText("UNABLE TO RETRIEVE NAME");
                Main.remoteNameValue.setForeground(Color.RED);
            }
            try {
                this.inStream = this.connection.openInputStream();
            }
            catch (IOException e) {
                Main.handleException(e);
                e.printStackTrace();
            }
            this.bis = new BufferedInputStream(this.inStream);
            try {
                this.outputStream = new BufferedOutputStream(this.connection.openOutputStream());
            }
            catch (IOException e) {
                Main.handleException(e);
                Main.connectionInfoValue.setText("Connection lost.");
                Main.connectionInfoValue.setForeground(Color.RED);
            }
            System.out.println("BufferedInputStream set, waiting for input.");
            byte[] lineRead = new byte[1024];
            try {
                while (this.bis.read(lineRead) != -1) {
                    this.handleMouseMovement(lineRead);
                }
                alive = false;
                if (!bluetoothShowing) continue;
                this.task.cancel();
                System.out.println("bis.read(lineRead) returned -1");
                this.bis.close();
                this.outputStream.close();
                this.connection.close();
                Main.renewBluetooth();
            }
            catch (IOException e) {
                Main.handleException(e);
                try {
                    this.bis.close();
                    this.outputStream.close();
                    this.connection.close();
                    this.streamConnNotifier.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                System.out.println("Exception in bis.read(lineRead)");
            }
            catch (InterruptedException e) {
                Main.handleException(e);
            }
        }
    }

    private void handleMouseMovement(byte[] lineRead) throws InterruptedException, IOException {
        byte[] yVal;
        byte[] xVal;
        System.out.println("\nStopping here 4");
        this.heartbeat = 30;
        if (lineRead[0] == -50 && lineRead[1] == -50) {
            StringBuffer buffer = new StringBuffer();
            int i = 2;
            while (lineRead[i] != -51) {
                buffer.append((char)lineRead[i]);
                ++i;
            }
            String url = buffer.toString();
            System.out.println(url);
            CustomUtilities.openUrl(url);
            return;
        }
        if (lineRead[0] == -70 && lineRead[1] == -70 && lineRead[12] == -72 && lineRead[13] == -72) {
            xVal = new byte[]{lineRead[2], lineRead[3], lineRead[4], lineRead[5]};
            yVal = new byte[]{lineRead[8], lineRead[9], lineRead[10], lineRead[11]};
            this.sendMouseMovement(xVal, yVal);
        }
        if (lineRead[0] == -80 && lineRead[1] == -80 && lineRead[12] == -82 && lineRead[13] == -82) {
            xVal = new byte[]{lineRead[2], lineRead[3], lineRead[4], lineRead[5]};
            yVal = new byte[]{lineRead[8], lineRead[9], lineRead[10], lineRead[11]};
            this.sendScrollMovement(xVal, yVal);
        }
        if (lineRead[0] == lineRead[1] && lineRead[0] >= 31 && lineRead[0] <= 127) {
            CustomUtilities.keyPress(this.r, lineRead);
            return;
        }
        PointerInfo a = MouseInfo.getPointerInfo();
        Point b = a.getLocation();
        int x = (int)b.getX();
        int y = (int)b.getY();
        this.dx = lineRead[0];
        this.dy = lineRead[1];
        if (this.dx <= -100 && this.dy <= -100) {
            block20: {
                System.out.println("Checksum received: " + this.dx + " " + this.dy);
                this.dx = (byte)(this.dx + 1);
                this.dy = (byte)(this.dy + 1);
                byte[] buf = new byte[]{this.dx, this.dy};
                try {
                    this.outputStream.write(buf);
                    this.outputStream.flush();
                    System.out.println("Checksum returned");
                    Main.connectionInfoValue.setText("ESTABLISHED");
                    Main.connectionInfoValue.setForeground(CustomUtilities.modernBlue);
                    this.task = new Timer();
                    this.task.scheduleAtFixedRate(new TimerTask(){

                        @Override
                        public void run() {
                            if (SimpleSPPServer.this.heartbeat != 0) {
                                --SimpleSPPServer.this.heartbeat;
                                System.out.println("Heartbeat = " + SimpleSPPServer.this.heartbeat);
                            } else {
                                try {
                                    SimpleSPPServer.this.bis.close();
                                    SimpleSPPServer.this.outputStream.close();
                                    SimpleSPPServer.this.connection.close();
                                    SimpleSPPServer.this.streamConnNotifier.close();
                                    Main.renewBluetooth();
                                    System.out.println("Renew 7");
                                    SimpleSPPServer.this.task.cancel();
                                    SimpleSPPServer.this.task.purge();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }, 1000L, 1000L);
                    alive = true;
                    devName = this.dev.getFriendlyName(true);
                    if (Main.trayIcon != null && !Main.mainFrame.isVisible()) {
                        Main.trayIcon.displayMessage("New Connection", "Device name: " + this.dev.getFriendlyName(true), TrayIcon.MessageType.NONE);
                    }
                }
                catch (IOException e) {
                    Main.handleException(e);
                    Main.connectionInfoValue.setText("CONNECTION LOST");
                    Main.connectionInfoValue.setForeground(Color.RED);
                    if (Main.trayIcon == null || Main.mainFrame.isVisible()) break block20;
                    Main.trayIcon.displayMessage("Disconnection", "Device no longer connected", TrayIcon.MessageType.NONE);
                }
            }
            return;
        }
        if (this.dx == -98 && this.dy == -98) {
            this.r.mousePress(4096);
            this.r.mouseRelease(4096);
        } else if (this.dx == -99 && this.dy == -99) {
            this.r.mousePress(1024);
            this.r.mouseRelease(1024);
        } else if (this.dx == -97 && this.dy == -97) {
            this.r.mousePress(2048);
            this.r.mouseRelease(2048);
        } else if (this.dx == -96 && this.dy == -96) {
            System.out.println("Heartbeat");
            this.outputStream.write(lineRead);
            this.outputStream.flush();
        } else if (this.dx == -95 && this.dy == -95) {
            this.r.mousePress(1024);
        } else if (this.dx == -94 && this.dy == -94) {
            this.r.mouseRelease(1024);
        }
    }

    private void sendMouseMovement(byte[] xVal, byte[] yVal) throws InterruptedException {
        this.mx = (double)ByteBuffer.wrap(xVal).getFloat() * CustomUtilities.SCREEN_HEIGHT_MOD;
        this.my = (double)ByteBuffer.wrap(yVal).getFloat() * CustomUtilities.SCREEN_HEIGHT_MOD;
        CustomUtilities.moveMouse(this.r, 80, 15, this.mx, this.my);
    }

    private void sendScrollMovement(byte[] xVal, byte[] yVal) {
        try {
            this.mx = (double)ByteBuffer.wrap(xVal).getFloat() * CustomUtilities.SCREEN_HEIGHT_MOD;
            this.my = (double)ByteBuffer.wrap(yVal).getFloat() * CustomUtilities.SCREEN_HEIGHT_MOD;
        }
        catch (BufferUnderflowException e) {
            System.out.println("No problem.");
        }
        this.r.mouseWheel((int)this.my);
    }

    public void closeBluetooth() {
        bluetoothShowing = false;
        try {
            this.bis.close();
            this.outputStream.close();
            this.connection.close();
            this.streamConnNotifier.close();
            System.out.println("Renew 7");
            this.task.cancel();
            this.task.purge();
            Main.renewBluetooth();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

