/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Robot;
import java.awt.TrayIcon;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;

public class ServerSocketMain
implements Runnable {
    public static boolean wifiShowing = false;
    public Robot r = null;
    public int dx;
    public int dy;
    protected Socket client = null;
    protected Socket hostClient;
    protected BufferedInputStream bis = null;
    ServerSocket serverSocket = null;
    ServerSocket hostnameServer;
    public boolean link = false;
    public boolean movement = false;
    public boolean half = false;
    public StringBuffer linkString;
    public ByteArrayOutputStream byteHolder;
    public byte[] xVal;
    public byte[] yVal;
    private double mx;
    private double my;
    public String compName;
    public String ipAddress;
    private boolean scroll;
    private static int heartbeat = 5;
    Timer task;
    public static boolean alive;

    @Override
    public void run() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                wifiShowing = true;
                try {
                    ServerSocketMain.this.hostnameServer = new ServerSocket(60121);
                }
                catch (SocketException e) {
                    Main.handleException(e);
                }
                catch (IOException e) {
                    Main.handleException(e);
                }
                while (!ServerSocketMain.this.hostnameServer.isClosed()) {
                    try {
                        ServerSocketMain.this.compName = InetAddress.getLocalHost().getHostName();
                        ServerSocketMain.this.hostClient = ServerSocketMain.this.hostnameServer.accept();
                        PrintWriter out = new PrintWriter(ServerSocketMain.this.hostClient.getOutputStream(), true);
                        System.out.print("Sending string: '" + ServerSocketMain.this.compName + "'\n");
                        out.print(ServerSocketMain.this.compName);
                        out.flush();
                        out.close();
                        ServerSocketMain.this.hostClient.close();
                    }
                    catch (IOException e) {
                        System.out.println("Try");
                    }
                }
                System.out.println("Closed.");
            }
        }).start();
        try {
            this.serverSocket = new ServerSocket(60120);
        }
        catch (SocketException e) {
            Main.handleException(e);
        }
        catch (IOException e) {
            Main.handleException(e);
        }
        byte[] recieveData = new byte[2];
        try {
            Main.ipAddressValue.setText(InetAddress.getLocalHost().getHostAddress());
            this.ipAddress = InetAddress.getLocalHost().getHostAddress();
            Main.ipAddressValue.setForeground(CustomUtilities.modernGreen);
        }
        catch (UnknownHostException e) {
            Main.handleException(e);
            Main.ipAddressValue.setText("UNABLE TO RETRIEVE LOCAL IP");
            Main.ipAddressValue.setForeground(Color.RED);
        }
        Main.nameValue.setText(this.compName);
        Main.nameValue.setForeground(CustomUtilities.modernGreen);
        try {
            this.r = new Robot();
        }
        catch (AWTException e) {
            Main.handleException(e);
            Main.connectionStatusValue.setText("MOUSE UNAVAILABLE");
            Main.connectionStatusValue.setForeground(Color.RED);
        }
        while (!this.serverSocket.isClosed()) {
            try {
                this.client = this.serverSocket.accept();
                this.client.setTcpNoDelay(true);
                System.out.println("Working?!");
                heartbeat = 5;
                this.bis = new BufferedInputStream(this.client.getInputStream());
                Main.connectionStatusValue.setText("ESTABLISHED");
                Main.connectionStatusValue.setForeground(CustomUtilities.modernGreen);
                alive = true;
                this.task = new Timer();
                this.task.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        if (heartbeat != 0) {
                            heartbeat--;
                        } else {
                            System.out.println("Here?!4");
                            try {
                                ServerSocketMain.this.bis.close();
                                ServerSocketMain.this.client.close();
                                ServerSocketMain.this.task.cancel();
                                ServerSocketMain.this.task.purge();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, 1000L, 1000L);
                if (Main.trayIcon != null && !Main.mainFrame.isVisible()) {
                    Main.trayIcon.displayMessage("New Connection", "Wifi: " + InetAddress.getLocalHost().getHostAddress(), TrayIcon.MessageType.NONE);
                }
            }
            catch (IOException e) {
                Main.handleException(e);
            }
            byte[] data = new byte[2];
            if (this.bis != null) {
                try {
                    while (this.bis.read(data) != -1) {
                        this.handleIncomingData(data);
                    }
                    System.out.println("Here?!2");
                    this.task.cancel();
                    this.task.purge();
                    this.bis.close();
                    this.client.close();
                }
                catch (IOException e) {
                    Main.handleException(e);
                }
            }
            alive = false;
            Main.connectionStatusValue.setText("DISCONNECTED");
            Main.connectionStatusValue.setForeground(Color.BLACK);
            if (Main.trayIcon == null || Main.mainFrame.isVisible()) continue;
            Main.trayIcon.displayMessage("Disconnection", "Device no longer connected", TrayIcon.MessageType.NONE);
        }
    }

    private void handleIncomingData(byte[] data) throws IOException {
        heartbeat = 5;
        if (this.link) {
            if (data[0] == -51 && data[1] == -51) {
                this.link = false;
                String url = this.linkString.toString();
                System.out.println("LINK RECEIVED: " + url);
                if (!url.substring(url.length() - 1, url.length()).matches("[0-9a-zA-Z]+")) {
                    this.linkString.deleteCharAt(this.linkString.length() - 1);
                }
                url = this.linkString.toString();
                CustomUtilities.openUrl(url);
                return;
            }
            this.linkString.append((char)data[0]);
            this.linkString.append((char)data[1]);
            return;
        }
        if (this.movement) {
            if (this.half) {
                if (data[0] == -72 && data[1] == -72) {
                    this.movement = false;
                    this.half = false;
                    this.yVal = this.byteHolder.toByteArray();
                    this.byteHolder.reset();
                    try {
                        this.sendMouseMovement(this.xVal, this.yVal);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                this.byteHolder.write(data);
                return;
            }
            if (data[0] == -71 && data[1] == -71) {
                this.half = true;
                this.xVal = this.byteHolder.toByteArray();
                this.byteHolder.reset();
                return;
            }
            this.byteHolder.write(data);
            return;
        }
        if (this.scroll) {
            if (this.half) {
                if (data[0] == -82 && data[1] == -82) {
                    this.scroll = false;
                    this.half = false;
                    this.yVal = this.byteHolder.toByteArray();
                    this.byteHolder.reset();
                    this.sendScrollMovement(this.xVal, this.yVal);
                    return;
                }
                this.byteHolder.write(data);
                return;
            }
            if (data[0] == -81 && data[1] == -81) {
                this.half = true;
                this.xVal = this.byteHolder.toByteArray();
                this.byteHolder.reset();
                return;
            }
            this.byteHolder.write(data);
            return;
        }
        if (data[0] == -50 && data[1] == -50) {
            this.link = true;
            this.linkString = new StringBuffer();
            return;
        }
        if (data[0] == -70 && data[1] == -70) {
            this.movement = true;
            this.byteHolder = new ByteArrayOutputStream();
            return;
        }
        if (data[0] == -80 && data[1] == -80) {
            this.scroll = true;
            this.byteHolder = new ByteArrayOutputStream();
            return;
        }
        if (data[0] == data[1] && data[0] >= 31 && data[0] <= 127) {
            CustomUtilities.keyPress(this.r, data);
            return;
        }
        this.dx = data[0];
        this.dy = data[1];
        if (this.dx == -98 && this.dy == -98) {
            this.r.mousePress(4096);
            this.r.mouseRelease(4096);
        } else if (this.dx == -99 && this.dy == -99) {
            this.r.mousePress(1024);
            this.r.mouseRelease(1024);
        } else if (this.dx == -97 && this.dy == -97) {
            this.r.mousePress(2048);
            this.r.mouseRelease(2048);
        } else if (this.dx == -96 && this.dy == -96) {
            System.out.println("Heartbeat");
            this.client.getOutputStream().write(data);
            this.client.getOutputStream().flush();
        } else if (this.dx == -95 && this.dy == -95) {
            this.r.mousePress(1024);
        } else if (this.dx == -94 && this.dy == -94) {
            this.r.mouseRelease(1024);
        }
    }

    private void sendScrollMovement(byte[] xVal, byte[] yVal) {
        try {
            this.mx = (double)ByteBuffer.wrap(xVal).getFloat() * CustomUtilities.SCREEN_HEIGHT_MOD;
            this.my = (double)ByteBuffer.wrap(yVal).getFloat() * CustomUtilities.SCREEN_HEIGHT_MOD;
        }
        catch (BufferUnderflowException e) {
            System.out.println("No problem.");
        }
        this.r.mouseWheel((int)this.my);
    }

    private void sendMouseMovement(byte[] xVal, byte[] yVal) throws InterruptedException {
        try {
            this.mx = (double)ByteBuffer.wrap(xVal).getFloat() * CustomUtilities.SCREEN_HEIGHT_MOD;
            this.my = (double)ByteBuffer.wrap(yVal).getFloat() * CustomUtilities.SCREEN_HEIGHT_MOD;
        }
        catch (BufferUnderflowException e) {
            System.out.println("No problem.");
        }
        System.out.println("mx: " + this.mx + "my: " + this.my);
        CustomUtilities.moveMouse(this.r, 40, 20, this.mx, this.my);
    }
}

