/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.BindException;
import java.net.ServerSocket;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class Main {
    public static JFrame mainFrame;
    public static JLabel localAddress;
    public static JLabel localAddressValue;
    public static JLabel localName;
    public static JLabel localNameValue;
    public static JButton wifiDisconnect;
    public static Thread mmBluetoothThread;
    public static Thread mmWifiThread;
    public static ServerSocketMain SSM;
    public static SimpleSPPServer SPP;
    public static JLabel remoteAddress;
    public static JLabel remoteAddressValue;
    public static JLabel remoteName;
    public static JLabel remoteNameValue;
    public static JLabel connectionInfo;
    public static JLabel connectionInfoValue;
    public static JButton bluetoothDisconnect;
    public static JLabel ipAddress;
    public static JLabel ipAddressValue;
    public static JLabel name;
    public static JLabel nameValue;
    public static JLabel connectionStatus;
    public static JLabel connectionStatusValue;
    public static boolean consoleShowing;
    public static JTextArea consoleText;
    public static JScrollPane scrollBox;
    public static JButton copyClipBoard;
    public static TrayIcon trayIcon;
    public static SystemTray tray;

    public static void main(String[] args) throws IOException {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            Main.handleException(e);
        }
        mainFrame = new JFrame("MOUSEDROID");
        mainFrame.setDefaultCloseOperation(3);
        try {
            ServerSocket doubleRunTest = new ServerSocket(9999);
        }
        catch (BindException e1) {
            JOptionPane.showMessageDialog(mainFrame, "One instance of the MouseDroid client is already running.");
            System.exit(0);
        }
        if (SystemTray.isSupported()) {
            System.out.println("System tray is supported");
            tray = SystemTray.getSystemTray();
            BufferedImage image = ImageIO.read(Main.class.getResource("/images/testLogo.png"));
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Exiting...");
                    System.exit(0);
                }
            };
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem("Exit");
            defaultItem.addActionListener(exitListener);
            popup.add(defaultItem);
            defaultItem = new MenuItem("Open");
            defaultItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mainFrame.setVisible(true);
                    mainFrame.setExtendedState(0);
                }
            });
            popup.add(defaultItem);
            trayIcon = new TrayIcon(image, "MouseDroid", popup);
            trayIcon.setImageAutoSize(true);
        } else {
            System.out.println("System tray not supported");
        }
        mainFrame.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 1) {
                    try {
                        tray.add(trayIcon);
                        mainFrame.setVisible(false);
                        System.out.println("Added to systemTray");
                        if (SimpleSPPServer.bluetoothShowing) {
                            if (SimpleSPPServer.alive) {
                                trayIcon.displayMessage("Bluetooth Connected", "Remote Device: " + SimpleSPPServer.devName, TrayIcon.MessageType.NONE);
                            } else {
                                trayIcon.displayMessage("Listening for bluetooth", "Local Device: " + SimpleSPPServer.localDevName, TrayIcon.MessageType.NONE);
                            }
                        } else if (ServerSocketMain.wifiShowing) {
                            if (ServerSocketMain.alive) {
                                trayIcon.displayMessage("Wifi Connected", "Local IP: " + Main.SSM.ipAddress, TrayIcon.MessageType.NONE);
                            } else {
                                trayIcon.displayMessage("Listening for wifi", "Local IP: " + Main.SSM.ipAddress, TrayIcon.MessageType.NONE);
                            }
                        } else {
                            trayIcon.displayMessage("Minimized", "Unconnected", TrayIcon.MessageType.NONE);
                        }
                    }
                    catch (AWTException ex) {
                        System.out.println("Unable to add to systemTray");
                    }
                }
                if (e.getNewState() == 7) {
                    try {
                        tray.add(trayIcon);
                        mainFrame.setVisible(false);
                        System.out.println("Added to system tray");
                    }
                    catch (AWTException ex) {
                        System.out.println("Unable to add to system tray");
                    }
                }
                if (e.getNewState() == 6 || e.getNewState() == 0) {
                    tray.remove(trayIcon);
                    mainFrame.setVisible(true);
                    System.out.println("Tray icon removed");
                }
            }
        });
        mainFrame.setIconImage(ImageIO.read(Main.class.getClassLoader().getResource("images/testLogo.png")));
        trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() >= 2) {
                    mainFrame.setVisible(true);
                    mainFrame.setExtendedState(0);
                }
            }
        });
        Container content = mainFrame.getContentPane();
        final JButton wifiButton = new JButton();
        wifiButton.setSize(512, 512);
        BufferedImage wifiImg = ImageIO.read(Main.class.getResource("/images/wi_fi.png"));
        wifiButton.setIcon(new ImageIcon(wifiImg));
        wifiButton.setDisabledIcon(new ImageIcon(wifiImg));
        final JButton bluetoothButton = new JButton();
        bluetoothButton.setSize(512, 512);
        BufferedImage bluetoothImg = ImageIO.read(Main.class.getResource("/images/bluetooth.png"));
        bluetoothButton.setIcon(new ImageIcon(bluetoothImg));
        bluetoothButton.setDisabledIcon(new ImageIcon(bluetoothImg));
        GridLayout layout = new GridLayout(1, 2);
        mainFrame.setLayout(layout);
        name = new JLabel("COMPUTER NAME:");
        nameValue = new JLabel("N/A");
        name.setVisible(false);
        nameValue.setVisible(false);
        ipAddress = new JLabel("IP ADDRESS:");
        ipAddressValue = new JLabel("N/A");
        ipAddress.setVisible(false);
        ipAddressValue.setVisible(false);
        connectionStatus = new JLabel("CONNECTION STATUS:");
        connectionStatusValue = new JLabel("DISCONNECTED");
        connectionStatus.setVisible(false);
        connectionStatusValue.setVisible(false);
        wifiDisconnect = new JButton("DISCONNECT");
        final JPanel bluetoothPanel = new JPanel();
        bluetoothPanel.setLayout(new BoxLayout(bluetoothPanel, 1));
        bluetoothPanel.add(bluetoothButton);
        localAddress = new JLabel("LOCAL DEVICE ADDRESS:");
        localAddressValue = new JLabel("N/A");
        localAddress.setVisible(false);
        localAddressValue.setVisible(false);
        localName = new JLabel("LOCAL DEVICE NAME:");
        localNameValue = new JLabel("N/A");
        localName.setVisible(false);
        localNameValue.setVisible(false);
        remoteAddress = new JLabel("REMOTE DEVICE ADDRESS:");
        remoteAddressValue = new JLabel("N/A");
        remoteAddress.setVisible(false);
        remoteAddressValue.setVisible(false);
        remoteName = new JLabel("REMOTE DEVICE NAME:");
        remoteNameValue = new JLabel("N/A");
        remoteName.setVisible(false);
        remoteNameValue.setVisible(false);
        connectionInfo = new JLabel("CURRENT CONNECTION STATUS:");
        connectionInfoValue = new JLabel("N/A");
        connectionInfo.setVisible(false);
        connectionInfoValue.setVisible(false);
        bluetoothDisconnect = new JButton("DISCONNECT");
        final JPanel wifiPanel = new JPanel();
        wifiPanel.setLayout(new BoxLayout(wifiPanel, 1));
        wifiPanel.add(wifiButton);
        content.add(wifiPanel);
        content.add(bluetoothPanel);
        wifiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSM = new ServerSocketMain();
                Thread thread = new Thread(SSM);
                thread.start();
                mmWifiThread = thread;
                wifiButton.setEnabled(false);
                bluetoothButton.setVisible(false);
                bluetoothPanel.remove(bluetoothButton);
                bluetoothPanel.setLayout(new GridLayout(8, 1));
                bluetoothPanel.add(name);
                name.setFont(name.getFont().deriveFont(1, 16.0f));
                bluetoothPanel.add(nameValue);
                nameValue.setBorder(new EmptyBorder(0, 50, 0, 0));
                nameValue.setFont(new Font("Lucida sans regular", 1, 32));
                bluetoothPanel.add(ipAddress);
                ipAddress.setFont(ipAddress.getFont().deriveFont(1, 16.0f));
                bluetoothPanel.add(ipAddressValue);
                ipAddressValue.setBorder(new EmptyBorder(0, 50, 0, 0));
                ipAddressValue.setFont(new Font("Lucida sans regular", 1, 32));
                bluetoothPanel.add(connectionStatus);
                connectionStatus.setFont(connectionStatus.getFont().deriveFont(1, 16.0f));
                bluetoothPanel.add(connectionStatusValue);
                connectionStatusValue.setBorder(new EmptyBorder(0, 50, 0, 0));
                connectionStatusValue.setFont(new Font("Lucida sans regular", 1, 32));
                bluetoothPanel.add(new JSeparator(0));
                bluetoothPanel.add(wifiDisconnect);
                wifiDisconnect.setFont(wifiDisconnect.getFont().deriveFont(24.0f));
                ipAddress.setVisible(true);
                ipAddressValue.setVisible(true);
                name.setVisible(true);
                nameValue.setVisible(true);
                connectionStatus.setVisible(true);
                connectionStatusValue.setVisible(true);
                bluetoothPanel.setBorder(BorderFactory.createTitledBorder(null, "Wifi connection", 2, 2, new Font("Arial", 1, 16), Color.BLUE));
                bluetoothPanel.repaint();
            }
        });
        bluetoothButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (System.getProperty("os.name").equals("Mac OS X")) {
                    JOptionPane.showMessageDialog(mainFrame, "MouseDroid Bluetooth is not supported on Mac OS X");
                    return;
                }
                SPP = new SimpleSPPServer();
                Thread thread = new Thread(SPP);
                thread.start();
                mmBluetoothThread = thread;
                bluetoothButton.setEnabled(false);
                wifiButton.setVisible(false);
                wifiPanel.remove(wifiButton);
                wifiPanel.setLayout(new GridLayout(12, 1));
                wifiPanel.add(localName);
                localName.setFont(localName.getFont().deriveFont(1, 16.0f));
                wifiPanel.add(localNameValue);
                localNameValue.setBorder(new EmptyBorder(0, 50, 0, 0));
                localNameValue.setFont(new Font("Lucida sans regular", 1, 32));
                wifiPanel.add(localAddress);
                localAddress.setFont(localAddress.getFont().deriveFont(1, 16.0f));
                wifiPanel.add(localAddressValue);
                localAddressValue.setBorder(new EmptyBorder(0, 50, 0, 0));
                localAddressValue.setFont(new Font("Lucida sans regular", 1, 32));
                wifiPanel.add(remoteAddress);
                remoteAddress.setFont(remoteAddress.getFont().deriveFont(1, 16.0f));
                wifiPanel.add(remoteAddressValue);
                remoteAddressValue.setBorder(new EmptyBorder(0, 50, 0, 0));
                remoteAddressValue.setFont(new Font("Lucida sans regular", 1, 32));
                wifiPanel.add(remoteName);
                remoteName.setFont(remoteName.getFont().deriveFont(1, 16.0f));
                wifiPanel.add(remoteNameValue);
                remoteNameValue.setBorder(new EmptyBorder(0, 50, 0, 0));
                remoteNameValue.setFont(new Font("Lucida sans regular", 1, 32));
                wifiPanel.add(connectionInfo);
                connectionInfo.setFont(connectionInfo.getFont().deriveFont(1, 16.0f));
                wifiPanel.add(connectionInfoValue);
                connectionInfoValue.setBorder(new EmptyBorder(0, 50, 0, 0));
                connectionInfoValue.setFont(new Font("Lucida sans regular", 1, 32));
                wifiPanel.add(new JSeparator(0));
                wifiPanel.add(bluetoothDisconnect);
                bluetoothDisconnect.setFont(bluetoothDisconnect.getFont().deriveFont(24.0f));
                localAddress.setVisible(true);
                localAddressValue.setVisible(true);
                localNameValue.setVisible(true);
                localName.setVisible(true);
                remoteAddress.setVisible(true);
                remoteAddressValue.setVisible(true);
                remoteName.setVisible(true);
                remoteNameValue.setVisible(true);
                connectionInfo.setVisible(true);
                connectionInfoValue.setVisible(true);
                wifiPanel.setBorder(BorderFactory.createTitledBorder(null, "Bluetooth connection", 2, 2, new Font("Arial", 1, 16), Color.BLUE));
                wifiPanel.repaint();
            }
        });
        bluetoothDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                wifiPanel.removeAll();
                wifiPanel.setBorder(null);
                wifiPanel.setLayout(new BoxLayout(wifiPanel, 1));
                wifiPanel.add(wifiButton);
                wifiButton.setVisible(true);
                wifiButton.setEnabled(true);
                bluetoothButton.setEnabled(true);
                mainFrame.repaint();
                SPP.closeBluetooth();
            }
        });
        wifiDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Main.SSM.hostnameServer != null && !Main.SSM.hostnameServer.isClosed()) {
                    try {
                        Main.SSM.hostnameServer.close();
                        System.out.println("Hostname closed");
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (Main.SSM.serverSocket != null && !Main.SSM.serverSocket.isClosed()) {
                    try {
                        if (Main.SSM.client != null) {
                            Main.SSM.client.close();
                        }
                        Main.SSM.serverSocket.close();
                        System.out.println("SSM closed");
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                connectionStatusValue.setText("DISCONNECTED");
                connectionStatusValue.setForeground(Color.BLACK);
                bluetoothPanel.removeAll();
                bluetoothPanel.setBorder(null);
                bluetoothPanel.setLayout(new BoxLayout(bluetoothPanel, 1));
                bluetoothPanel.add(bluetoothButton);
                bluetoothButton.setVisible(true);
                bluetoothButton.setEnabled(true);
                wifiButton.setEnabled(true);
                mainFrame.repaint();
                Main.renewWifi();
            }
        });
        mainFrame.setResizable(false);
        mainFrame.setVisible(true);
        mainFrame.pack();
        mainFrame.setLocationRelativeTo(null);
        mainFrame.setFocusable(true);
        bluetoothPanel.setFocusable(true);
        consoleText.setEditable(false);
        scrollBox.setVerticalScrollBarPolicy(22);
        scrollBox.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                e.getAdjustable().setValue(e.getAdjustable().getMaximum());
            }
        });
        copyClipBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection stringSelection = new StringSelection(consoleText.getText());
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(stringSelection, null);
            }
        });
        KeyListener consoleStart = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char key = e.getKeyChar();
                if (!(key != '`' && key != '~' || consoleShowing)) {
                    Main.showConsole();
                }
                System.out.println("Hey");
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        mainFrame.addKeyListener(consoleStart);
        bluetoothPanel.addKeyListener(consoleStart);
    }

    private static void showConsole() {
        consoleShowing = true;
        JFrame console = new JFrame("Console");
        console.setSize(400, 300);
        console.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                consoleShowing = false;
                super.windowClosed(e);
            }
        });
        console.getContentPane().add(scrollBox);
        console.getContentPane().add((Component)copyClipBoard, "South");
        console.setVisible(true);
        console.setResizable(false);
    }

    public static void renewWifi() {
        ServerSocketMain.wifiShowing = false;
        SSM = new ServerSocketMain();
    }

    public static void renewBluetooth() {
        System.out.println("Has it exited the loop?");
        remoteAddressValue.setText("N/A");
        remoteAddressValue.setForeground(Color.BLACK);
        remoteNameValue.setText("N/A");
        remoteNameValue.setForeground(Color.BLACK);
        connectionInfoValue.setText("DISCONNECTED");
        connectionInfoValue.setForeground(Color.BLACK);
        if (Main.SPP.connection != null) {
            try {
                Main.SPP.connection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SPP = new SimpleSPPServer();
    }

    public static void handleException(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        consoleText.append(sw.toString());
        e.printStackTrace();
    }

    static {
        consoleShowing = false;
        consoleText = new JTextArea("Visit http://droidmouse.org/faq on how to report an error.\n====================================================\n");
        scrollBox = new JScrollPane(consoleText);
        copyClipBoard = new JButton("Copy to clipboard");
    }
}

