/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Desktop;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.Toolkit;
import java.net.URI;

public class CustomUtilities {
    public static final double SCREEN_WIDTH_MOD = Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 1000.0;
    public static final double SCREEN_HEIGHT_MOD = Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 1000.0;
    public static final Color modernGreen = Color.decode("#8AAB34");
    public static final Color modernBlue = Color.decode("#2546E9");

    public static void openUrl(String s) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(s));
            }
            catch (Exception e) {
                Main.handleException(e);
            }
        } else {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("xdg-open " + s);
            }
            catch (Exception e) {
                Main.handleException(e);
            }
        }
    }

    private static void typeKey(Robot r, int vkSpace) {
        r.keyPress(vkSpace);
        r.keyRelease(vkSpace);
    }

    private static void typeShiftKey(Robot r, int vkSpace) {
        r.keyPress(16);
        r.keyPress(vkSpace);
        r.keyRelease(16);
        r.keyRelease(vkSpace);
    }

    public static void keyPress(Robot r, byte[] data) {
        switch (data[0]) {
            case 31: {
                CustomUtilities.typeKey(r, 10);
                break;
            }
            case 32: {
                CustomUtilities.typeKey(r, 32);
                break;
            }
            case 33: {
                CustomUtilities.typeShiftKey(r, 49);
                break;
            }
            case 34: {
                CustomUtilities.typeShiftKey(r, 222);
                break;
            }
            case 35: {
                CustomUtilities.typeShiftKey(r, 51);
                break;
            }
            case 36: {
                CustomUtilities.typeShiftKey(r, 52);
                break;
            }
            case 37: {
                CustomUtilities.typeShiftKey(r, 53);
                break;
            }
            case 38: {
                CustomUtilities.typeShiftKey(r, 55);
                break;
            }
            case 39: {
                CustomUtilities.typeKey(r, 222);
                break;
            }
            case 40: {
                CustomUtilities.typeShiftKey(r, 57);
                break;
            }
            case 41: {
                CustomUtilities.typeShiftKey(r, 48);
                break;
            }
            case 42: {
                CustomUtilities.typeShiftKey(r, 56);
                break;
            }
            case 43: {
                CustomUtilities.typeKey(r, 107);
                break;
            }
            case 44: {
                CustomUtilities.typeKey(r, 44);
                break;
            }
            case 45: {
                CustomUtilities.typeKey(r, 45);
                break;
            }
            case 46: {
                CustomUtilities.typeKey(r, 46);
                break;
            }
            case 47: {
                CustomUtilities.typeKey(r, 47);
                break;
            }
            case 58: {
                CustomUtilities.typeShiftKey(r, 59);
                break;
            }
            case 59: {
                CustomUtilities.typeKey(r, 59);
                break;
            }
            case 60: {
                CustomUtilities.typeShiftKey(r, 44);
                break;
            }
            case 61: {
                CustomUtilities.typeKey(r, 61);
                break;
            }
            case 62: {
                CustomUtilities.typeShiftKey(r, 46);
                break;
            }
            case 63: {
                CustomUtilities.typeShiftKey(r, 47);
                break;
            }
            case 64: {
                CustomUtilities.typeShiftKey(r, 50);
                break;
            }
            case 91: {
                CustomUtilities.typeKey(r, 91);
                break;
            }
            case 92: {
                CustomUtilities.typeKey(r, 92);
                break;
            }
            case 93: {
                CustomUtilities.typeKey(r, 93);
                break;
            }
            case 94: {
                CustomUtilities.typeShiftKey(r, 54);
                break;
            }
            case 95: {
                CustomUtilities.typeShiftKey(r, 45);
                break;
            }
            case 96: {
                CustomUtilities.typeKey(r, 192);
                break;
            }
            case 123: {
                CustomUtilities.typeShiftKey(r, 91);
                break;
            }
            case 124: {
                CustomUtilities.typeShiftKey(r, 92);
                break;
            }
            case 125: {
                CustomUtilities.typeShiftKey(r, 93);
                break;
            }
            case 126: {
                CustomUtilities.typeShiftKey(r, 192);
                break;
            }
            case 127: {
                CustomUtilities.typeKey(r, 8);
                break;
            }
            default: {
                if (data[0] >= 97 && data[0] <= 122) {
                    CustomUtilities.typeKey(r, data[0] - 32);
                    break;
                }
                if (data[0] >= 65 && data[0] <= 90) {
                    CustomUtilities.typeShiftKey(r, data[0]);
                    break;
                }
                CustomUtilities.typeKey(r, data[0]);
            }
        }
    }

    public static void moveMouse(Robot r, int t, int n, double mx, double my) {
        PointerInfo a = MouseInfo.getPointerInfo();
        Point b = a.getLocation();
        int x = (int)b.getX();
        int y = (int)b.getY();
        r.mouseMove((int)((double)x + mx), (int)((double)y + my));
    }
}

